﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.ServiceModel;
using System.Text;
using VIRP.CRS.BO;
using VIRP.CRS.BLL;
using VIRP.ViaService;

namespace VIRP.CRS.DAL
{
    public class ViaDb : DBUtils
    {
        public EmrSvcInterfaceClient CreateVIAClient(string CURRENT_USER)
        {
            EmrSvcInterfaceClient tsic = null;

            try
            {
                Uri uri = new Uri(ViaServiceUrl);
                bool secure = uri.Scheme.Equals("https", StringComparison.OrdinalIgnoreCase);
                System.ServiceModel.Channels.Binding binding = BuildBinding(secure);
                EndpointAddress address = new EndpointAddress(uri);
                tsic = new EmrSvcInterfaceClient(binding, address);
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, 0);
                throw;
            }

            if (null != tsic)
            {
                return tsic;
            }

            return null;
        }

        private static System.ServiceModel.Channels.Binding BuildBinding(bool secure)
        {
            //eventually need to get all of this from DB
            System.ServiceModel.BasicHttpBinding result = new System.ServiceModel.BasicHttpBinding(secure ? BasicHttpSecurityMode.Transport : BasicHttpSecurityMode.None);
            result.CloseTimeout = TimeSpan.Parse("00:01:00");
            result.OpenTimeout = TimeSpan.Parse("00:01:00");
            result.ReceiveTimeout = TimeSpan.Parse("00:10:00");
            result.SendTimeout = TimeSpan.Parse("00:01:00");
            result.AllowCookies = false;
            result.BypassProxyOnLocal = false;
            result.HostNameComparisonMode = HostNameComparisonMode.StrongWildcard;
            result.MaxBufferSize = 65536;
            result.MaxBufferPoolSize = 524288L;
            result.MaxReceivedMessageSize = 65536L;
            result.MessageEncoding = WSMessageEncoding.Text;
            result.TextEncoding = Encoding.UTF8;
            result.TransferMode = TransferMode.Buffered;
            result.UseDefaultWebProxy = true;
            result.ReaderQuotas.MaxDepth = 32;
            result.ReaderQuotas.MaxStringContentLength = 8192;
            result.ReaderQuotas.MaxArrayLength = 16384;
            result.ReaderQuotas.MaxBytesPerRead = 4096;
            result.ReaderQuotas.MaxNameTableCharCount = 16384;
            result.Security.Transport.ClientCredentialType = HttpClientCredentialType.None;
            result.Security.Transport.ProxyCredentialType = HttpProxyCredentialType.None;
            result.Security.Transport.Realm = "";
            result.Security.Message.ClientCredentialType = BasicHttpMessageCredentialType.UserName;
            result.Security.Message.AlgorithmSuite = System.ServiceModel.Security.SecurityAlgorithmSuite.Default;
            //Only supports two modes: Transport for https and None for http
            result.Security.Mode = secure ? BasicHttpSecurityMode.Transport : BasicHttpSecurityMode.None; //use URL to determine
            return result;
        }

        public ViaPerson CPRSLaunch(string CURRENT_USER, string duz, string dfn, string loginSiteCode)
        {
            ViaService.EmrSvcInterfaceClient service = CreateVIAClient(CURRENT_USER);
            ViaPerson result = null;
            personsTO temp = null;

            //*** DO NOT OVERRIDE THE _loginSiteCode IN THIS METHOD
            try
            {
                provider providerbean = new provider();
                patient patientbean = new patient();
                queryBean bean = new queryBean();

                string userID = duz;
                string providerDfn = dfn;
                string localPid = dfn;

                bean.criteria = "TBI_PWD";
                bean.requestingApp = ViaRequestingApp;
                bean.consumingAppToken = ViaAppToken;
                bean.consumingAppPassword = ViaAppKey;
                //patient attributes
                patientbean.localSiteId = loginSiteCode;
                patientbean.localPid = dfn;
                bean.patient = patientbean;
                //provider attributes
                providerbean.loginSiteCode = loginSiteCode;
                providerbean.userId = userID;
                bean.provider = providerbean;

                // We want to use the value we saved in the session UNLESS
                // the site code has changed (this happens when TBI can't determine the users
                // site and they select it from the pick-list provided
                //if (HttpContext.Current.Session["_VIAService.cprsLaunch"] == null ||
                //    HttpContext.Current.Session["_loginSiteCode"] == null ||
                //    _loginSiteCode != Convert.ToString(HttpContext.Current.Session["_loginSiteCode"]))
                //{
                temp = service.cprsLaunch(bean);
                result = new ViaPerson(temp);
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, 0);
                throw;
            }

            return result;
        }

        public List<StringKeyValuePair> GetNoteTitles(string CURRENT_USER, string target, string direction, out string error, string loginSiteCode, string dfn, string duz, string providerName)
        {
            ViaService.EmrSvcInterfaceClient service = CreateVIAClient(CURRENT_USER);
            ViaService.taggedTextArray ret = null;
            List<StringKeyValuePair> result = null;

            string searchParameter = String.Empty;

            searchParameter = target.Trim().ToUpper();

            try
            {
                if (service != null)
                {
                    queryBean bean = new queryBean();
                    patient patientbean = new patient();
                    provider providerbean = new provider();

                    //loginSiteCode = stationDivision;

                    bean.target = searchParameter;
                    bean.direction = "1";
                    bean.requestingApp = ViaRequestingApp;
                    bean.consumingAppToken = ViaAppToken;
                    bean.consumingAppPassword = ViaAppKey;
                    patientbean.localSiteId = loginSiteCode;
                    patientbean.localPid = dfn;
                    providerbean.name = providerName;
                    providerbean.userId = duz;
                    providerbean.loginSiteCode = loginSiteCode;
                    bean.patient = patientbean;
                    bean.provider = providerbean;

                    ret = service.getNoteTitles(bean);

                    if (ret != null)
                    {
                        if (ret.fault != null)
                        {
                            error = ret.fault.message;
                            result = null;
                        }
                        else
                        {
                            if (ret.count > 0)
                            {
                                error = "SUCCESS";
                                List<taggedText> orderedResults = (from e in ret.results.FirstOrDefault().taggedResults orderby e.text select e).ToList();
                                foreach (taggedText t in orderedResults)
                                {
                                    if (result == null)
                                        result = new List<StringKeyValuePair>();

                                    result.Add(new StringKeyValuePair(t.tag, t.textArray[0]));
                                }
                            }
                            else
                            {
                                error = null;
                            }
                        }
                    }
                    else
                    {
                        error = "VIA Service call get Note Titles returned null";
                    }
                }
                else
                {
                    error = null;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, 0);
                throw;
            }

            return result;
        }

        public List<StringKeyValuePair> GetLocations(string CURRENT_USER, string searchParameter, string direction, out string error, string loginSiteCode, string dfn, string providerName, string duz)
        {
            ViaService.EmrSvcInterfaceClient service = CreateVIAClient(CURRENT_USER);
            var result = new List<StringKeyValuePair>();
            ViaService.taggedHospitalLocationArray ret = null;

            try
            {
                queryBean bean = new queryBean();
                patient patientbean = new patient();
                provider providerbean = new provider();

                bean.target = searchParameter.Trim().ToUpper();
                bean.requestingApp = ViaRequestingApp;
                bean.consumingAppToken = ViaAppToken;
                bean.consumingAppPassword = ViaAppKey;
                bean.direction = direction;
                patientbean.localSiteId = loginSiteCode;
                providerbean.loginSiteCode = loginSiteCode;
                patientbean.localPid = dfn;
                providerbean.name = providerName;
                providerbean.userId = duz;
                bean.patient = patientbean;
                bean.provider = providerbean;

                ret = service.getLocations(bean);

                if (ret != null)
                {
                    if (ret.fault != null)
                    {
                        error = ret.fault.message;
                    }
                    else
                    {
                        if (!(ret.count == 0 || ret.locations == null))
                        {
                            error = "SUCCESS";
                            //result = (from e in ret.locations orderby e.name select new StringKeyValuePair(e.id, e.name)).ToList();
                            List<hospitalLocationTO> orderedResults = (from e in ret.locations orderby e.name select e).ToList();
                            foreach (hospitalLocationTO t in orderedResults)
                            {
                                if (result == null)
                                    result = new List<StringKeyValuePair>();

                                result.Add(new StringKeyValuePair(t.id, t.name));
                            }
                        }
                        else
                        {
                            error = null;
                        }
                    }
                }
                else
                {
                    error = "VIA Service call get Locations returned null";
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, 0);
                throw;
            }

            return result;
        }

        public List<StringKeyValuePair> GetConsults(string CURRENT_USER, out string error, string loginSiteCode, string dfn, string providerName, string duz)
        {
            ViaService.EmrSvcInterfaceClient service = CreateVIAClient(CURRENT_USER);
            var result = new List<StringKeyValuePair>();
            ViaService.taggedConsultArrays ret = null;

            try
            {
                if (service != null)
                {
                    queryBean bean = new queryBean();
                    patient patientbean = new patient();
                    provider providerbean = new provider();

                    bean.requestingApp = ViaRequestingApp;
                    bean.consumingAppToken = ViaAppToken;
                    bean.consumingAppPassword = ViaAppKey;
                    patientbean.localPid = dfn;
                    patientbean.localSiteId = loginSiteCode;
                    providerbean.name = providerName;
                    providerbean.userId = duz;
                    providerbean.loginSiteCode = loginSiteCode;
                    bean.patient = patientbean;
                    bean.provider = providerbean;

                    ret = service.getConsultsForPatient(bean);

                    if (ret != null)
                    {
                        if (ret.fault != null)
                        {
                            error = ret.fault.message;
                        }
                        else
                        {
                            error = "SUCCESS";
                            if (!(ret.count == 0 || ret.arrays[0].consults == null))
                            {
                                if (ret.arrays[0].consults.Count() > 0 && ret.arrays[0].consults[0].timestamp != null)
                                {
                                    var consultsArray = ret.arrays.SelectMany(s => s.consults).ToList();
                                    //result = (from e in consultsArray orderby e.timestamp descending select new StringKeyValuePair(e.id, DateTime.ParseExact(e.timestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture).ToString("MMM dd,yy") + " (" + e.status + ") " + e.title + " " + "Consult #: " + e.id)).ToList();
                                    List<consultTO> orderedResults = (from e in consultsArray orderby e.timestamp descending select e).ToList();
                                    foreach (consultTO t in orderedResults)
                                    {
                                        if (result == null)
                                            result = new List<StringKeyValuePair>();

                                        result.Add(new StringKeyValuePair(t.id, DateTime.ParseExact(t.timestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture).ToString("MMM dd,yy") + " (" + t.status + ") " + t.title + " " + "Consult #: " + t.id));
                                    }
                                }
                                else
                                {
                                    error = null;
                                }
                            }
                            else
                            {
                                error = null;
                            }
                        }
                    }
                    else
                    {
                        error = "VIA Service call get Consults returned null";
                    }
                }
                else
                {
                    error = null;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, 0);
                throw;
            }

            return result;
        }

        public List<StringKeyValuePair> GetHospitalAdmissions(string CURRENT_USER, out string error, string loginSiteCode, string dfn, string providerName, string duz, string patientIcn)
        {
            ViaService.EmrSvcInterfaceClient service = CreateVIAClient(CURRENT_USER);
            var result = new List<StringKeyValuePair>();
            ViaService.taggedInpatientStayArray ret = null;

            try
            {
                queryBean bean = new queryBean();
                patient patientbean = new patient();
                provider providerbean = new provider();

                patientbean.localPid = dfn;
                patientbean.localSiteId = loginSiteCode;
                patientbean.mpiPid = patientIcn;
                providerbean.loginSiteCode = loginSiteCode;
                providerbean.name = providerName;
                providerbean.userId = duz;
                bean.patient = patientbean;
                bean.provider = providerbean;
                bean.requestingApp = ViaRequestingApp;
                bean.consumingAppToken = ViaAppToken;
                bean.consumingAppPassword = ViaAppKey;

                ret = service.getAdmissions(bean);

                if (ret != null)
                {
                    if (ret.fault != null)
                    {
                        //_mdwsLog.ERROR_LEVEL = 1;
                        error = ret.fault.message;
                    }
                    else
                    {
                        if (!(ret.count == 0 || ret.stays == null))
                        {
                            //_mdwsLog.ERROR_LEVEL = 0;
                            error = "SUCCESS";
                            //result = (from e in ret.stays orderby e.admitTimestamp descending select new StringKeyValuePair(e.location.id + ";" + FormatDateForVIA2(DateTime.ParseExact(e.admitTimestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture)) + ";H", e.location.name + " (" + DateTime.ParseExact(e.admitTimestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture).ToString("MMM dd,yy") + ")")).ToList();
                            List<inpatientStayTO> orderedResults = (from e in ret.stays orderby e.admitTimestamp select e).ToList();
                            foreach (inpatientStayTO t in orderedResults)
                            {
                                if (result == null)
                                    result = new List<StringKeyValuePair>();

                                result.Add(new StringKeyValuePair(t.location.id + ";" + FormatDateForVIA2(DateTime.ParseExact(t.admitTimestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture)) + ";H", t.location.name + " (" + DateTime.ParseExact(t.admitTimestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture).ToString("MMM dd,yy") + ")"));
                            }
                        }
                        else
                        {
                            //_mdwsLog.ERROR_LEVEL = 1;
                            error = null;
                        }
                    }
                }
                else
                {
                    error = "VIA Service call get Hospital Admissions returned null";
                    //_mdwsLog.ERROR_LEVEL = 2;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, 0);
                throw;
            }

            return result;
        }

        public List<StringKeyValuePair> GetVisits(string CURRENT_USER, DateTime fromDate, DateTime toDate, out string error, string loginSiteCode, string dfn, string providerName, string duz, string patientIcn)
        {
            ViaService.EmrSvcInterfaceClient service = CreateVIAClient(CURRENT_USER);
            ViaService.taggedVisitArray ret = null;
            var result = new List<StringKeyValuePair>();

            string formattedFromDate = FormatDateForVIA(fromDate);
            string formattedToDate = FormatDateForVIA(toDate);

            try
            {
                queryBean bean = new queryBean();
                patient patientbean = new patient();
                provider providerbean = new provider();

                bean.recordSiteCode = loginSiteCode;
                bean.requestingApp = ViaRequestingApp;
                bean.consumingAppToken = ViaAppToken;
                bean.consumingAppPassword = ViaAppKey;
                bean.startDate = formattedFromDate;
                bean.endDate = formattedToDate;
                patientbean.localPid = dfn;
                patientbean.localSiteId = loginSiteCode;
                patientbean.mpiPid = patientIcn;
                providerbean.name = providerName;
                providerbean.loginSiteCode = loginSiteCode;
                providerbean.userId = duz;

                bean.patient = patientbean;
                bean.provider = providerbean;

                ret = service.getVisits(bean);

                if (ret != null)
                {
                    if (ret.fault != null)
                    {
                        error = ret.fault.message;
                        result = null;

                        //_mdwsLog.ERROR_LEVEL = 1;
                    }
                    else
                    {
                        if (ret.count > 0)
                        {
                            //_mdwsLog.ERROR_LEVEL = 0;
                            error = "SUCCESS";
                            //result = (from e in ret.visits orderby e.timestamp descending select new StringKeyValuePair(e.location.id + ";" + FormatDateForVIA2(DateTime.ParseExact(e.timestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture)) + ";A", DateTime.ParseExact(e.timestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture).ToString("g") + " " + e.location.name + " " + e.status)).ToList();
                            List<visitTO> orderedResults = (from e in ret.visits orderby e.timestamp descending select e).ToList();
                            foreach (visitTO t in orderedResults)
                            {
                                if (result == null)
                                    result = new List<StringKeyValuePair>();

                                result.Add(new StringKeyValuePair(t.location.id + ";" + FormatDateForVIA2(DateTime.ParseExact(t.timestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture)) + ";A", DateTime.ParseExact(t.timestamp, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture).ToString("g") + " " + t.location.name + " " + t.status));
                            }
                        }
                        else
                        {
                            error = null;
                            //_mdwsLog.ERROR_LEVEL = 1;
                        }
                    }
                }
                else
                {
                    error = "VIA Service call get Visits returned null";
                    throw new Exception(ret.fault.message);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, 0);
                throw;
            }

            //mdwsLog.LogMDWSCall(_mdwsLog);

            return result;
        }

        private string FormatDateForVIA(DateTime dateValue)
        {
            if (dateValue != null)
            {
                //return (dateValue.Year - 1700) + "" + dateValue.ToString("MM") + dateValue.ToString("dd") + "." + dateValue.ToString("HH") + dateValue.ToString("mm") + dateValue.ToString("ss");
                return dateValue.Year + "" + dateValue.ToString("MM") + dateValue.ToString("dd");
            }
            else
            {
                return null;
            }
        }

        private string FormatDateForVIA2(DateTime dateValue)
        {
            // CPRS is expecting date in the following format "20000101.000000";
            //  [yyyy -1700]MMdd.HHmmss.  For example, 3130715.163242 represents the date and time of JUL 15, 2013 at 16:32:42
            //return String.Format("{0:yyyyMMdd}", dateValue);

            if (dateValue != null)
            {
                return (dateValue.Year - 1700) + "" + dateValue.ToString("MM") + dateValue.ToString("dd") + "." + dateValue.ToString("HH") + dateValue.ToString("mm") + dateValue.ToString("ss");
            }
            else
            {
                return null;
            }
        }

        public string WriteNote(string CURRENT_USER, string titleIEN, string encounterString, string noteText, string authorDUZ, string cosignerDUZ, string consultIEN, string prfIEN, string loginSiteCode, string dfn, string providerName, string duz)
        {
            string strReturn = string.Empty;
            ViaService.EmrSvcInterfaceClient service = CreateVIAClient(CURRENT_USER);
            ViaService.noteResultTO writeNoteResult = new ViaService.noteResultTO();

            try
            {
                queryBean bean = new queryBean();
                patient patientbean = new patient();
                provider providerbean = new provider();

                //if (!string.IsNullOrEmpty(StationDivision))
                //    tbiServiceTO.StationNumber = StationDivision;
                //var _loginSiteCode = tbiServiceTO.StationNumber;
                bean.requestingApp = ViaRequestingApp;
                bean.consumingAppToken = ViaAppToken;
                bean.consumingAppPassword = ViaAppKey;
                patientbean.localPid = dfn;
                providerbean.loginSiteCode = loginSiteCode;
                providerbean.userId = duz;

                providerbean.name = providerName;

                bean.patient = patientbean;
                bean.provider = providerbean;

                writeNoteResult = service.writeNote(titleIEN, encounterString, noteText, authorDUZ, cosignerDUZ, consultIEN, prfIEN, bean);
                strReturn = "Success";
                //    if (!String.IsNullOrEmpty(_writeNoteResult.id))
                //    {

                //        mdwsLog.LogMDWSCall(_mdwsLog); // log via entry
                //        savedFlag = true;

                //        CloseNoteWithVIA(titleIEN, consultIEN);
                //    }
            }
            catch (Exception ex)
            {
                strReturn = "Error";
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, 0);
                throw;
            }

            return strReturn;
        }

        public enum NoteTypeEnum : int
        {
            ScheduledClinicAppointment = 0,
            HospitalAdmission = 1,
            CurrentStay = 2,
            UnscheduledOrNewVisit = 3
        }
    }
}
